/*
 * Created on Feb 3, 2006
 *
 * Reads the supplied list of 0506 XML files and converts them to 0405.
 * It does not change any totals.  These will have to be manually dealt with.  
 */
package subproc.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

/**
 * @author Gary
 * 
 *         Assumes that the XML is "beautified" . More specifically, each XML
 *         tag is terminated with "\n"
 */
public class Converter0506to0405 {

    private static void convert(final StringBuffer xml, final String path, final String fileName) {

        if (xml.toString().equals("")) {
            return;
        }

        int from = 0;
        int to = 0;

        // Change GovTalkMessage header
        from = xml.indexOf("<GovTalk");
        to = xml.indexOf("\n", from);
        replace(xml, from, to, "<GovTalkMessage xmlns=\"http://www.govtalk.gov.uk/CM/envelope\">\n");

        // Add NICHolday after SAPcompensation
        from = findEndOf(xml, "<SAPcompensation>");
        if (from > -1) {
            replace(xml, from, from, "<NICholiday>0.00</NICholiday>\n");
        }

        // Add EmployerAddress after EmployerName
        from = findEndOf(xml, "<EmployerName>");
        replace(xml, from, from, "<EmployerAddress>\n" + "<Line>Gary House</Line>\n" + "<Line>Gary Street</Line>\n"
                + "<Line>Gary Town</Line>\n" + "</EmployerAddress>");

        // Add TotalNicHolidayClaimed
        from = findEndOf(xml, "<TotalSSP>");
        if (from > -1) {
            replace(xml, from, from, "<TotalNICHolidayClaimed>0.00</TotalNICHolidayClaimed>");
        }

        // Remove IncentivePayment
        from = xml.indexOf("<IncentivePayment>");
        to = xml.indexOf("\n", from);
        if (from > -1) {
            replace(xml, from, to, "<!-- REMOVED INCENTIVE PAYMENT -->");
        }

        // Change PeriodEnd
        from = xml.indexOf("<PeriodEnd>");
        to = xml.indexOf("\n", from);
        replace(xml, from, to, "<PeriodEnd>2005-04-05</PeriodEnd>");

        // Write the file back
        writeFile(xml, path, fileName);
    }

    /**
     * Finds the end of tag
     * 
     * @param xml
     * @param string
     * @return returns the index of where the end of the tag was found
     */
    private static int findEndOf(final StringBuffer xml, final String string) {
        final int from = xml.indexOf(string);
        if (from < 0) {
            return from;
        }
        return xml.indexOf("\n", from);
    }

    private static void replace(final StringBuffer xml, final int replaceFrom, final int replaceTo, final String replaceWith) {
        xml.replace(replaceFrom, replaceTo, replaceWith);
    }

    private static void writeFile(final StringBuffer xml, final String destPath, String fileName) {
        try {
            fileName = destPath + File.separator + "new-" + fileName;
            final Writer writer = new FileWriter(fileName);
            writer.write(xml.toString());
            writer.close();
        } catch (final IOException e1) {
            e1.printStackTrace();
        }
    }

    public static StringBuffer readFileIntoStringBuffer(final String fileName) {

        final StringBuffer sb = new StringBuffer();
        String line = null;
        FileReader fr;

        try {
            fr = new FileReader(fileName);
            final BufferedReader br = new BufferedReader(fr);

            while ((line = br.readLine()) != null) {
                sb.append(line + "\n");
            }

            br.close();

        } catch (final FileNotFoundException e) {
            e.printStackTrace();
        } catch (final IOException e) {
            e.printStackTrace();
        }
        return sb;
    }

    public static void main(final String[] args) {

        final long startTime = System.currentTimeMillis();
        final String pathName = "C:\\temp\\0506to0405\\";

        final String[] fileNames = { "TOL01-OC-001.xml", "TOL01-OC-003.xml", "TOL01-OC-004.xml", "TOL01-OC-006.xml",
                "TOL01-OC-008.xml", "TOL01-OC-010.xml", "TOL04-OC-018.xml" };

        for (final String element : fileNames) {
            convert(readFileIntoStringBuffer(pathName + element), pathName, element);
        }

        final long endTime = System.currentTimeMillis();
        /*
         * @see
         * http://beastie/pm/default.asp?pg=pgEditBug&command=view&ixBug=27&
         * ixBugEventLatest=195
         */
        System.out.println("Complete in " + (endTime - startTime) + "ms");
    }
}
