/*
 * Created on Nov 7, 2005
 * 
 * $Id: JDOMGeneratorListTest.java,v 1.16 2006/08/10 15:19:11 dec Exp $
 */
package test.ericResponse.output;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import junit.framework.TestCase;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

import processingError.ErrorProcessor;
import processingError.Location;
import processingError.ProcessingError;
import ericResponse.output.EricResponseParams;
import ericResponse.output.JDOMGeneratorList;
import ericResponse.output.error.ERErrorDetail;
import ericResponse.output.error.EricResponseError;
import ericResponse.output.error.EricResponseErrorBean;

/**
 * @author Douglas Clinton
 * @since Nov 7, 2005
 */
public class JDOMGeneratorListTest extends TestCase {

    private static final ProcessingError PROCESSING_ERROR;

    static {
        PROCESSING_ERROR = new ProcessingError() {
            public Object getValueInError() {
                return "somevalue";
            }

            public String getRuleName() {
                throw new UnsupportedOperationException("implement me!");
            }

            public Location getLocation() {
                throw new UnsupportedOperationException("implement me!");
            }

            public String getDescription() {
                throw new UnsupportedOperationException("implement me!");
            }

            public String getSubCode() {
                throw new UnsupportedOperationException("implement me!");
            }

            public Object getExtraInfo() {
                return null;
            }

            public ErrorProcessor getErrorProcessor() {
                throw new UnsupportedOperationException("implement me!");
            }

            public ProcessingError getChainedError() {
                throw new UnsupportedOperationException("implement me!");
            }

            public Object getOriginalError() {
                return this;
            }

            public String getErrorCode() {
                return null;
            }

            public String getMessage() {
                return null;
            }

            public String getXPathLocation() {
                throw new UnsupportedOperationException("implement me!");
            }

            public List<?> getApplicationData() {
                return Collections.emptyList();
            }
        };
    }

    @SuppressWarnings("unchecked")
    public void testBuildJDOMTree() {
        final ERErrorDetail detail = new ERErrorDetail();
        detail.setCode("1");
        detail.setLocator("Tag");
        detail.setMessageText("error");

        final EricResponseError ere = new EricResponseErrorBean(detail, PROCESSING_ERROR);

        final List<EricResponseError> ereList = new ArrayList<EricResponseError>();
        ereList.add(ere);

        final JDOMGeneratorList jdl = new JDOMGeneratorList(ereList, new EricResponseParams());

        {
            final Element e = jdl.get(0);
            assertEquals("MessageCount", e.getName());
        }
        {
            final Element e = jdl.get(1);
            assertEquals("Error", e.getName());

            final List<Element> children = e.getChildren();
            final String[] elementTexts = { "IR-ERSS", "1", "business-rule", "error", "Tag" };
            for (int i = 0; i < elementTexts.length; i++) {
                final Element child = children.get(i);
                assertEquals(elementTexts[i], child.getText());
            }
        }
    }

    @SuppressWarnings("unchecked")
    public void testBuildJDOMTreeMultipleErrors() {

        final EricResponseParams params = new EricResponseParams();
        params.setOutputExtraDetails(false);

        final ERErrorDetail detail = new ERErrorDetail();
        detail.setCode("1");
        detail.setLocator("Tag");
        detail.setMessageText("error");
        final EricResponseError ere = new EricResponseErrorBean(detail, PROCESSING_ERROR);

        final ERErrorDetail detail2 = new ERErrorDetail();
        detail2.setCode("2");
        detail2.setLocator("Tag-2");
        detail2.setMessageText("error-2");
        final EricResponseError ere2 = new EricResponseErrorBean(detail2, PROCESSING_ERROR);

        final List<EricResponseError> ereList = new ArrayList<EricResponseError>();
        ereList.add(ere);
        ereList.add(ere2);

        final JDOMGeneratorList jdl = new JDOMGeneratorList(ereList, params);

        final String[][] elementTexts = { { "IR-ERSS", "1", "business-rule", "error", "Tag" },
                { "IR-ERSS", "2", "business-rule", "error-2", "Tag-2" } };

        final Document doc = new Document();
        final Element root = new Element("Root");

        doc.setRootElement(root);

        {
            final Element e = jdl.get(0);
            assertEquals(e.getName(), "MessageCount");
        }

        for (int j = 0; j < 2; j++) {
            final Element e = jdl.get(j + 1);
            final List<Element> children = e.getChildren();

            root.addContent(e);
            {
                final Element child = children.get(0);
                assertEquals(elementTexts[j][0], child.getText());
            }
            {
                final Element child = children.get(1);
                assertEquals(elementTexts[j][1], child.getText());
            }
            {
                final Element child = children.get(2);
                assertEquals(elementTexts[j][2], child.getText());
            }
            {
                final Element child = children.get(3);
                assertEquals(elementTexts[j][3], child.getText());
            }
        }

        final XMLOutputter outputter = new XMLOutputter();
        final OutputStream outputStream = new ByteArrayOutputStream();

        try {
            outputter.output(root, outputStream);
        } catch (final IOException f) {
            f.printStackTrace();
            assertFalse(true);
        }

        final String expected = "<Root><Error><RaisedBy>IR-ERSS</RaisedBy><Number>1</Number><Type>business-rule</Type><Text>error</Text><Location>Tag</Location></Error><Error><RaisedBy>IR-ERSS</RaisedBy><Number>2</Number><Type>business-rule</Type><Text>error-2</Text><Location>Tag-2</Location></Error></Root>";
        final String actual = outputStream.toString();
        assertEquals(expected, actual);

    }

}
