/*
 * Created on Nov 15, 2005
 *
 * $Id: TestEricResponseErrorBean.java,v 1.6 2005/12/01 14:26:46 kwalch Exp $
 */
package test.ericResponse.output;

import junit.framework.TestCase;
import ericResponse.output.error.ERErrorDetail;
import ericResponse.output.error.EricErrorType;
import ericResponse.output.error.EricResponseErrorBean;

/**
 * Test for: EricResponseErrorBean.
 */
public class TestEricResponseErrorBean extends TestCase {
    public void testErrorType() {

        final ERErrorDetail detail = new ERErrorDetail();

        final EricResponseErrorBean ericResponseErrorBean = new EricResponseErrorBean(detail, null);

        // legal schema error codes are..
        detail.setCode("5012");
        assertEquals(EricErrorType.SCHEMA_VALIDATION, ericResponseErrorBean.getErrorType());

        detail.setCode("5016");
        assertEquals(EricErrorType.SCHEMA_VALIDATION, ericResponseErrorBean.getErrorType());

        detail.setCode("6010");
        assertEquals(EricErrorType.SCHEMA_VALIDATION, ericResponseErrorBean.getErrorType());

        // the remaining are business error codes
        detail.setCode("1234");
        assertEquals(EricErrorType.BUSINESS_RULE, ericResponseErrorBean.getErrorType());
    }
}
