/**
 * $Id: BusinessRuleTestCase.java,v 1.3 2006/08/09 18:22:42 dec Exp $
 */
package test.paye.eoy.bizrules;

import java.util.List;

import junit.framework.TestCase;
import paye.eoy.bizrules.PAYEIRNamespaceMapping;
import paye.multiyear.TaxYear;
import processingError.ProcessingError;
import bizrules.BusinessRule;

import com.gsl.docValidator.CurrentDate;
import com.gsl.docValidator.DocValidatorTestUtil;

/**
 * @author Doug Clinton
 * 
 * @since 23-Feb-2006
 */
public abstract class BusinessRuleTestCase extends TestCase {

    protected BusinessRuleErrorCollector errorCollector = new BusinessRuleErrorCollector();

    protected List<ProcessingError> getErrors() {
        return errorCollector.getErrors();
    }

    public BusinessRuleTestCase() {
        init();
    }

    protected void initializeRule(final BusinessRule rule) {
        init();
        errorCollector.clearErrors();
        rule.setErrorCollector(errorCollector);
    }

    protected boolean checkErrorRaised(final BusinessRule rule, final String subCode) {
        return errorCollector.contains(rule, subCode);
    }

    private void init() {
        CurrentDate.initTestMode(DocValidatorTestUtil.NOW);
        TaxYear.setIRNamespaceMapping(PAYEIRNamespaceMapping.getInstance());
    }
}
