/*
 * Created on Jun 2, 2005
 * 
 * $Id: CombinedLessStatutoryRecovered.java,v 1.1 2006/04/08 09:26:25 dec Exp $
 *  
 */
package test.paye.eoy.bizrules.br0607;

import paye.eoy.bizrules.p35.br0607.CombinedLessStatutoryPaymentsRule;
import test.paye.eoy.bizrules.BusinessRuleTestCase;

/**
 * @author Rob
 */
public class CombinedLessStatutoryRecoveredTest extends BusinessRuleTestCase {

    private final CombinedLessStatutoryPaymentsRule rule = new CombinedLessStatutoryPaymentsRule();

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        initializeRule(rule);
    }

    public void testRule134a() {
        rule.setTotalNICsTaxAndStudentLoan("25.00");
        rule.setNetStatutoryPaymentsRecovered("15.00");
        rule.setCombinedLessStatutoryRecovered("10.00");

        rule.processRule();
        assertTrue("Should not have thrown any errors", errorCollector.getErrors().size() == 0);
    }

    public void testRule134b() {
        rule.setTotalNICsTaxAndStudentLoan("25.00");
        rule.setNetStatutoryPaymentsRecovered("15.00");
        rule.setCombinedLessStatutoryRecovered("15.00");
        rule.processRule();
        assertTrue("Should have thrown a Rule133.1 error", errorCollector.contains(rule,
                CombinedLessStatutoryPaymentsRule.BAD_TOTAL));
    }

}
