/*
 * Created on Jun 2, 2005
 * 
 * $Id: TotalAmountPayableRuleTest.java,v 1.2 2006/05/12 10:02:57 dec Exp $
 *  
 */
package test.paye.eoy.bizrules.br0607;

import java.util.List;

import paye.eoy.bizrules.p35.br0607.TotalAmountPayableRuleB;
import processingError.ProcessingError;
import test.paye.eoy.bizrules.BusinessRuleTestCase;

public class TotalAmountPayableRuleTest extends BusinessRuleTestCase {
    private final TotalAmountPayableRuleB rule = new TotalAmountPayableRuleB();

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        initializeRule(rule);
    }

    public void testRule135a() {
        rule.setCombinedLessStatutoryRecovered("50.00");
        // +
        rule.setSubcontractorTax("10.00");
        // =
        rule.setTotalPayable("60.00");

        rule.processRule();
        final List<ProcessingError> errors = errorCollector.getErrors();
        assertTrue("Should NOT have thrown any errors", errors.size() == 0);
    }

    public void testRule135b() {
        rule.setCombinedLessStatutoryRecovered("50.00");
        // +
        rule.setSubcontractorTax("10.00");
        // =
        rule.setTotalPayable("0.00");
        rule.processRule();
        final List<ProcessingError> errors = errorCollector.getErrors();
        assertTrue("Should have thrown a Rule133.1 error", errors.size() == 1);
    }

}
