/*
 * Created on Jun 1, 2005
 * 
 * $Id: TotalTaxRuleTest.java,v 1.1 2006/04/08 09:26:25 dec Exp $
 *  
 */
package test.paye.eoy.bizrules.br0607;

import java.util.List;

import paye.eoy.bizrules.p35.AbstractTotalTaxRule;
import paye.eoy.bizrules.p35.br0607.TotalTaxRuleB;
import processingError.ProcessingError;
import test.paye.eoy.bizrules.BusinessRuleTestCase;
import bizrules.BusinessRuleError;

/**
 * @author Jaco
 */
public class TotalTaxRuleTest extends BusinessRuleTestCase {

    private final TotalTaxRuleB rule = new TotalTaxRuleB();

    public TotalTaxRuleTest() {
        super();
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        initializeRule(rule);
    }

    public void testRule117point1a() {
        rule.setP14Tax("10.00");

        rule.setTaxAdvance("20.00");
        rule.setTotalTax("30.00");
        rule.processRule();
        final List<ProcessingError> errors = errorCollector.getErrors();
        assertTrue("Should not have thrown any errors", errors.size() == 0);
    }

    public void testRule117point1b() {
        rule.setP14Tax("10.00");
        rule.setTaxAdvance("20.00");
        rule.setTotalTax("70.00");
        rule.processRule();
        final List<ProcessingError> errors = errorCollector.getErrors();
        assertTrue("should have been one error", errors.size() == 1);
        final BusinessRuleError businessRuleError = (BusinessRuleError) errors.get(0);
        assertTrue("Should have thrown a Rule117.1 error", AbstractTotalTaxRule.BAD_TOTAL.equals(businessRuleError.getSubCode()));
    }

}
