package test.paye.eoy.bizrules.header;

import paye.eoy.bizrules.header.EmployersReferenceRule;
import test.paye.eoy.bizrules.BusinessRuleTestCase;
import xmldoc.Attribute;
import xmldoc.AttributeDetail;

public class EmployersReferenceRuleTest extends BusinessRuleTestCase {
    private EmployersReferenceRule rule;

    private final Attribute[] keyAttributes = new Attribute[] { new AttributeDetail("Type", "TaxOfficeReference") };

    @Override
    public void setUp() {
        rule = new EmployersReferenceRule();
        initializeRule(rule);
    }

    public void testSuccessCase() {
        rule.setKey(keyAttributes);
        rule.setKey("1234ab");

        rule.processRule();

        assertTrue("Should not have raised any errors", errorCollector.getErrors().size() == 0);
    }

    public void testStartsWithSpace() {
        rule.setKey(keyAttributes);
        rule.setKey(" 12345");

        rule.processRule();

        assertTrue("Should have raised an error", checkErrorRaised(rule, EmployersReferenceRule.STARTS_WITH_SPACE));
    }

    public void testTooLong() {
        rule.setKey(keyAttributes);
        rule.setKey("12345678910");

        rule.processRule();

        assertTrue("Should have raised an error", checkErrorRaised(rule, EmployersReferenceRule.TOO_LONG));
    }

    public void testMandatory() {
        rule.setKey(keyAttributes);

        rule.processRule();

        assertTrue("Should have raised an error", checkErrorRaised(rule, EmployersReferenceRule.MANDATORY));
    }
}
