package test.paye.eoy.bizrules.header;

import paye.eoy.bizrules.header.IROfficeNumberRule;
import test.paye.eoy.bizrules.BusinessRuleTestCase;
import xmldoc.Attribute;
import xmldoc.AttributeDetail;
import xmldoc.DocumentError;

public class IROfficeNumberRuleTest extends BusinessRuleTestCase {
    private IROfficeNumberRule rule;

    private final Attribute[] keyAttributes = new Attribute[] { new AttributeDetail("Type", "TaxOfficeNumber") };

    @Override
    public void setUp() {
        rule = new IROfficeNumberRule();
        initializeRule(rule);
    }

    public void testSuccessCase() {
        rule.setKey(keyAttributes);
        rule.setKey("123");

        rule.processRule();

        assertTrue("Should not have raised any errors", errorCollector.getErrors().size() == 0);
    }

    public void testShortNumber() {
        rule.setKey(keyAttributes);
        rule.setKey("12");

        rule.processRule();

        assertTrue("Should have raised an error", checkErrorRaised(rule, DocumentError.FORMAT));
    }

    public void testLongNumber() {
        rule.setKey(keyAttributes);
        rule.setKey("1234");

        rule.processRule();

        assertTrue("Should have raised an error", checkErrorRaised(rule, DocumentError.FORMAT));
    }

    public void testBadNumber() {
        rule.setKey(keyAttributes);
        rule.setKey("1x3");

        rule.processRule();

        assertTrue("Should have raised an error", checkErrorRaised(rule, DocumentError.FORMAT));
    }

    public void testZero() {
        rule.setKey(keyAttributes);
        rule.setKey("000");

        rule.processRule();

        assertTrue("Should have raised an error", checkErrorRaised(rule, DocumentError.VALUE));
    }

    public void testMandatory() {
        rule.setKey(keyAttributes);

        rule.processRule();

        assertTrue("Should have raised an error", checkErrorRaised(rule, DocumentError.MANDATORY));
    }
}
