/*
 * Created on Jun 10, 2006
 *
 * $Id: BigDecimalUtilTest.java,v 1.1 2006/06/10 12:42:29 dec Exp $
 */
package test.paye.eoy.bizrules.helpers;

import java.math.BigDecimal;

import junit.framework.TestCase;
import paye.eoy.bizrules.helpers.BigDecimalUtil;

public class BigDecimalUtilTest extends TestCase {

    public void testBadString() {
        final BigDecimal bd = BigDecimalUtil.toBigDecimal("bad string");

        assertEquals(BigDecimalUtil.ZERO, bd);
    }

    public void testIntegerZero() {
        final BigDecimal bd = BigDecimalUtil.toBigDecimal("0");

        assertEquals(BigDecimalUtil.ZERO, bd);
    }

    public void testOneDPZero() {
        final BigDecimal bd = BigDecimalUtil.toBigDecimal("0.0");

        assertEquals(BigDecimalUtil.ZERO, bd);
    }

    public void testTwoDPZero() {
        final BigDecimal bd = BigDecimalUtil.toBigDecimal("0.00");

        assertEquals(BigDecimalUtil.ZERO, bd);
    }
}
