/*
 * Created on 30-May-2005
 * 
 * $Id: AbstractTotalTest.java,v 1.1 2006/04/08 09:26:25 dec Exp $
 *  
 */
package test.paye.eoy.bizrules.p14;

import java.util.List;

import paye.eoy.bizrules.qs3.AbstractTotalRule;
import processingError.ProcessingError;
import test.paye.eoy.bizrules.BusinessRuleTestCase;
import bizrules.BusinessRuleError;

/**
 * $Id: AbstractTotalTest.java,v 1.1 2006/04/08 09:26:25 dec Exp $
 * 
 */
public abstract class AbstractTotalTest extends BusinessRuleTestCase {

    private final AbstractTotalRule rule = newInstance();

    protected abstract AbstractTotalRule newInstance();

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        initializeRule(rule);
    }

    public void testTotals() {
        rule.setValue("1");
        rule.setValue("1");
        rule.setSuppliedTotal("2");
        rule.processRule();
        final List<ProcessingError> errors = errorCollector.getErrors();
        assertTrue("Should not have thrown any errors", errors.size() == 0);
    }

    public void testBadTotalError() {
        rule.setValue("1");
        rule.setValue("1");
        rule.setValue("1");
        rule.setSuppliedTotal("2");
        rule.processRule();
        final List<ProcessingError> errors = errorCollector.getErrors();
        assertTrue("should have been one error", errors.size() == 1);
        final BusinessRuleError businessRuleError = (BusinessRuleError) errors.get(0);
        assertTrue("Should have thrown 'bad total' error", "bad total".equals(businessRuleError.getSubCode()));
    }

}
