/*
 * Created on May 24, 2005
 * 
 * $Id: EmployeeDOBFormatRuleTest.java,v 1.1 2006/04/08 09:26:25 dec Exp $
 */
package test.paye.eoy.bizrules.p14;

import java.util.Date;
import java.util.List;

import paye.eoy.bizrules.p14.EmployeeDOBRule;
import paye.multiyear.DateHelper;
import processingError.ProcessingError;
import test.paye.eoy.bizrules.BusinessRuleTestCase;
import bizrules.BusinessRuleError;

/**
 * @author doug
 * @since May 24, 2005
 */
public class EmployeeDOBFormatRuleTest extends BusinessRuleTestCase {
    private final EmployeeDOBRule rule = new EmployeeDOBRule();

    private final String validDateString1 = "1901-01-01";

    private final String validDateString2 = "2005-05-23";

    private static final long ONE_DAY_IN_MILLIS = 24 * 60 * 60 * 1000;

    // Invalid because DOB should be today or earlier
    private final String tomorrowDateString = DateHelper.createDateFormat().format(
            new Date(System.currentTimeMillis() + ONE_DAY_IN_MILLIS));

    private final String todayDateString = DateHelper.createDateFormat().format(new Date());

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        initializeRule(rule);
    }

    public void testRule15DateFormatValid() {
        rule.setDateOfBirth(validDateString1);
        rule.processRule();
        List<ProcessingError> errors = errorCollector.getErrors();
        assertTrue("Should have no errors for date " + validDateString1, errors.size() == 0);

        rule.setDateOfBirth(validDateString2);
        rule.processRule();
        errors = errorCollector.getErrors();
        assertTrue("Should have no errors for date " + validDateString2, errors.size() == 0);
    }

    public void testTodayIsOkay() {
        rule.setDateOfBirth(todayDateString);
        rule.processRule();
        final List<ProcessingError> errors = errorCollector.getErrors();

        assertTrue("Should have no errors for today's date ", errors.size() == 0);
    }

    public void testRule15DateIsTomorrow() {
        rule.setDateOfBirth(tomorrowDateString);
        rule.processRule();
        final List<ProcessingError> errors = errorCollector.getErrors();
        final BusinessRuleError error = (BusinessRuleError) errors.get(0);

        assertTrue("Should have failed range check for date " + tomorrowDateString,
                EmployeeDOBRule.TOO_LATE.equals(error.getSubCode()));
    }
}
