/*
 * Created on May 23, 2005
 *
 * $Id: EmployeeForenameRuleTest.java,v 1.3 2006/06/07 19:25:56 dec Exp $
 */
package test.paye.eoy.bizrules.p14;

import java.util.List;

import paye.eoy.bizrules.p14.EmployeeForenameRule;
import processingError.ProcessingError;
import test.paye.eoy.bizrules.BusinessRuleTestCase;
import xmldoc.DocumentError;

/**
 * @author Jaco
 * 
 */
public class EmployeeForenameRuleTest extends BusinessRuleTestCase {

    private final EmployeeForenameRule rule = new EmployeeForenameRule();

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        initializeRule(rule);
    }

    public void testRule19a() {
        rule.setForename("rob");
        rule.processRule();
        final List<ProcessingError> errors = getErrors();
        assertTrue("Should not have given any errors", errors.size() == 0);
    }

    public void testRule19b() {
        rule.processRule();
        assertTrue("Should have given an mandatory error", checkErrorRaised(rule, DocumentError.MANDATORY));
    }

    public void testRule19c() {
        rule.setForename("");
        rule.processRule();
        assertTrue("Should have given error 2", checkErrorRaised(rule, DocumentError.BLANK));
    }

    public void testRule19d() {
        rule.setForename("0rob");
        rule.processRule();
        assertTrue("Should have given error", checkErrorRaised(rule, DocumentError.FORMAT));
    }

    public void testRule19e() {
        rule.setForename("r9b");
        rule.processRule();
        assertTrue("Should have given error", checkErrorRaised(rule, DocumentError.FORMAT));
    }

    public void testRule19f() {
        rule.setForename("A M");
        rule.processRule();
        assertTrue("Should have given error", checkErrorRaised(rule, DocumentError.FORMAT));
    }

    public void testRule19g() {
        rule.setForename("1A");
        rule.processRule();
        assertTrue("Should have given error", checkErrorRaised(rule, DocumentError.FORMAT));
    }

    public void testRule19h() {
        rule.setForename("A`ndy");
        rule.processRule();
        assertTrue("Should have given error", checkErrorRaised(rule, DocumentError.FORMAT));
    }

    public void testRule19i() {
        rule.setForename("AbcdefghijklmnopqrstuvwxyzAbcdefghihjlmnopqrstuvwxyz");
        rule.processRule();
        assertTrue("Should have given error", checkErrorRaised(rule, DocumentError.FORMAT));
    }
}
