/*
 * Created on January 31, 2006
 * $Id: EmployeeGenderRuleATest.java,v 1.1 2006/04/08 09:26:25 dec Exp $
 */
package test.paye.eoy.bizrules.p14;

import paye.eoy.bizrules.p14.EmployeeGenderRule;
import paye.multiyear.TaxYear;
import test.paye.eoy.bizrules.BusinessRuleTestCase;

/**
 * @author Rob
 */
public class EmployeeGenderRuleATest extends BusinessRuleTestCase {

    private static String validMale = "male";

    private static String validFemale = "female";

    /**
     * EmployeeGender rule relies on knowing the tax year.
     */
    private EmployeeGenderRule getRule() {
        return new EmployeeGenderRule() {
            @Override
            protected TaxYear getTaxYear() {
                return TaxYear.TAX_YEAR_0405;
            }
        };
    };
    
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        initializeRule(rule);
    }

    private final EmployeeGenderRule rule = getRule();

    public void testRule16point1a() {
        rule.setGender(validFemale);
        rule.processRule();
        assertTrue("Should not have reported any errors.", getErrors().size() == 0);
    }

    public void testRule16point1b() {
        rule.setGender(validMale);
        rule.processRule();
        assertTrue("Should not have reported any errors.", getErrors().size() == 0);

    }

}
