/*
 * Created on May 26, 2005
 *
 * $Id: FinalTaxCodeRuleTest.java,v 1.2 2006/06/06 14:57:09 dec Exp $
 * 
 */
package test.paye.eoy.bizrules.p14;

import paye.eoy.bizrules.p14.payandtax.FinalTaxCodeRule;
import test.paye.eoy.bizrules.BusinessRuleTestCase;

/**
 * @author Rob
 */
public class FinalTaxCodeRuleTest extends BusinessRuleTestCase {
    private final FinalTaxCodeRule rule = new FinalTaxCodeRule();

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        initializeRule(rule);
    }

    public void testRule43point1a() {
        rule.setTax("-4.00");
        rule.processRule();
        assertTrue("Should have thrown a Rule43.1 error", checkErrorRaised(rule, FinalTaxCodeRule.NO_CODE));
    }

    public void testRule43point1b() {
        rule.setTax("0.00");
        rule.processRule();
        assertTrue("Should not have thrown any errors", getErrors().size() == 0);
    }

}
