/*
 * Created on Jun 3, 2005
 *
 * $Id: P14PartTotalRecordCountRuleTest.java,v 1.3 2006/06/22 09:43:34 dec Exp $
 */
package test.paye.eoy.bizrules.p14;

import java.util.List;

import paye.eoy.bizrules.p14.AbstractP14CountCountCheck;
import paye.eoy.bizrules.p14.parttotals.P14PartTotalCountCheckRule;
import processingError.ProcessingError;
import test.paye.eoy.bizrules.BusinessRuleTestCase;
import bizrules.BusinessRuleError;

/**
 * @author Jaco
 */
public class P14PartTotalRecordCountRuleTest extends BusinessRuleTestCase {

    public void testInteger() {
        final AbstractP14CountCountCheck rule = new P14PartTotalCountCheckRule();
        initializeRule(rule);
        rule.setP14Count("1");
        rule.setP14("");
        rule.processRule();
        final List<ProcessingError> errors = getErrors();
        assertTrue("Should not have thrown any errors.", errors.size() == 0);
    }

    public void testRule58point1a() {
        final AbstractP14CountCountCheck rule = new P14PartTotalCountCheckRule();
        initializeRule(rule);
        rule.setP14Count("3");
        rule.setP14("");
        rule.setP14("");
        rule.setP14("");
        rule.processRule();
        final List<ProcessingError> errors = getErrors();
        assertTrue("Should not have thrown any errors.", errors.size() == 0);
    }

    public void testRule58point1b() {
        final AbstractP14CountCountCheck rule = new P14PartTotalCountCheckRule();
        initializeRule(rule);
        rule.setP14Count("10");
        rule.setP14("");
        rule.setP14("");
        rule.setP14("");
        rule.processRule();
        final List<ProcessingError> errors = getErrors();
        final BusinessRuleError error = (BusinessRuleError) errors.get(0);
        assertTrue("Should have thrown Rule58.1 error.", AbstractP14CountCountCheck.BAD_COUNT.equals(error.getSubCode()));
    }

}
