/*
 * Created on Jun 3, 2005
 *
 * $Id: P14RecordCountRuleTest.java,v 1.3 2006/06/22 09:43:34 dec Exp $
 */
package test.paye.eoy.bizrules.p14;

import paye.eoy.bizrules.p14.AbstractP14CountCountCheck;
import paye.eoy.bizrules.p14.P14CountCheckRuleAmended;
import paye.eoy.bizrules.p14.P14CountCheckRuleOriginal;
import paye.eoy.types.SubmissionType;
import test.paye.eoy.bizrules.BusinessRuleTestCase;
import bizrules.BusinessRuleError;

/**
 * @author Jaco
 */
public class P14RecordCountRuleTest extends BusinessRuleTestCase {

    public void testIntegerA() {
        final AbstractP14CountCountCheck rule = new P14CountCheckRuleAmended();
        initializeRule(rule);
        rule.setP14Count("0");

        rule.processRule();
        assertTrue("Should not have thrown any errors.", getErrors().size() == 0);
    }

    public void testIntegerO() {
        final AbstractP14CountCountCheck rule = new P14CountCheckRuleOriginal();
        initializeRule(rule);
        rule.setP14Count("0");
        rule.processRule();
        assertTrue("Should have thrown an error.", getErrors().size() == 1);
    }

    public void testInteger1() {
        final P14CountCheckRuleOriginal rule = new P14CountCheckRuleOriginal();
        initializeRule(rule);
        rule.setP14Count("0");
        rule.setCisDeductions("100.00");
        rule.processRule();
        assertTrue("Should not have thrown an error.", getErrors().size() == 0);
    }

    public void testInteger2() {
        final P14CountCheckRuleOriginal rule = new P14CountCheckRuleOriginal();
        initializeRule(rule);
        rule.setP14Count("0");
        rule.setCisDeductions("0.00");
        rule.processRule();
        assertTrue("Should have thrown an error.", getErrors().size() == 1);
    }

    public void testRule58point1aO() {

        final AbstractP14CountCountCheck rule = new P14CountCheckRuleOriginal();
        initializeRule(rule);
        rule.setP14Count("3");
        rule.setP14("");
        rule.setP14("");
        rule.setP14("");
        rule.processRule();
        assertTrue("Should not have thrown any errors.", getErrors().size() == 0);
    }

    public void testRule58point1aA() {
        final AbstractP14CountCountCheck rule = new P14CountCheckRuleAmended();
        initializeRule(rule);
        rule.setP14Count("3");
        rule.setP14("");
        rule.setP14("");
        rule.setP14("");
        rule.processRule();
        assertTrue("Should not have thrown any errors.", getErrors().size() == 0);
    }

    public void testRule58point1bO() {
        final AbstractP14CountCountCheck rule = new P14CountCheckRuleOriginal();
        initializeRule(rule);
        rule.setP14Count("10");
        rule.setP14("");
        rule.setP14("");
        rule.setP14("");
        rule.processRule();
        final BusinessRuleError error = (BusinessRuleError) getErrors().get(0);
        assertEquals("bad count", error.getSubCode());
    }

    public void testRule58point1bA() {
        final AbstractP14CountCountCheck rule = new P14CountCheckRuleAmended();
        initializeRule(rule);
        rule.setP14Count("10");
        rule.setP14("");
        rule.setP14("");
        rule.setP14("");
        rule.processRule();
        final BusinessRuleError error = (BusinessRuleError) getErrors().get(0);
        assertTrue("Should have thrown Rule58.1 error.", AbstractP14CountCountCheck.BAD_COUNT.equals(error.getSubCode()));
    }

    public void testRule58point1cO() {
        final AbstractP14CountCountCheck rule = new P14CountCheckRuleOriginal() {
            @Override
            protected SubmissionType getSubmissionType() {
                return SubmissionType.COMPLETE;
            }
        };
        initializeRule(rule);

        rule.setP14Count("0");

        rule.processRule();
        final BusinessRuleError error = (BusinessRuleError) getErrors().get(0);
        assertTrue("Should have thrown Rule58.1 error.", P14CountCheckRuleOriginal.SUPPLIED_COUNT_ZERO.equals(error.getSubCode()));
    }

    public void testRule58point1sA() {
        final AbstractP14CountCountCheck rule = new P14CountCheckRuleAmended() {
            @Override
            protected SubmissionType getSubmissionType() {
                return SubmissionType.P35PART;
            }
        };
        initializeRule(rule);

        rule.setP14Count("0");
        rule.processRule();
        assertTrue("Should NOT have thrown Rule58.1 error.", getErrors().size() == 0);
    }

}
