/*
 * Created on May 26, 2005
 * 
 * $Id: SMPRuleTest.java,v 1.1 2006/04/08 09:26:25 dec Exp $
 */
package test.paye.eoy.bizrules.p14;

import java.util.List;

import paye.eoy.bizrules.p14.SMPRule;
import processingError.ProcessingError;
import test.paye.eoy.bizrules.BusinessRuleTestCase;
import bizrules.BusinessRuleError;

/**
 * @author Doug
 */
public class SMPRuleTest extends BusinessRuleTestCase {
    private final SMPRule rule = new SMPRule();

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        initializeRule(rule);
    }

    public void testRule32point3a() {
        rule.setGender("male");
        rule.setSmp("0.00");
        rule.processRule();
        final List<ProcessingError> errors = getErrors();
        assertTrue("Should not have thrown any errors", errors.size() == 0);
    }

    public void testRule32point4a() {
        rule.setGender("male");
        rule.setSmp("3.00");
        rule.processRule();
        final List<ProcessingError> errors = getErrors();
        assertEquals(1, errors.size());
        final BusinessRuleError error = (BusinessRuleError) errors.get(0);
        assertEquals("Should have thrown a SMPRule.2 error", SMPRule.MUST_BE_ZERO_FOR_MALES, error.getSubCode());
    }

    public void testRule16point3() {
        rule.setSmp("3.00");
        rule.processRule();
        final List<ProcessingError> errors = getErrors();
        assertEquals(1, errors.size());
        final BusinessRuleError error = (BusinessRuleError) errors.get(0);
        assertEquals("Should have thrown a SMPRule.6 error", SMPRule.GENDER_REQUIRED, error.getSubCode());
    }

}
