/*
 * Created on May 26, 2005
 * 
 * $Id: TaxInPrevEmpRuleTest.java,v 1.2 2006/06/06 14:57:09 dec Exp $
 *  
 */
package test.paye.eoy.bizrules.p14;

import paye.eoy.bizrules.p14.payandtax.TaxInPrevEmpRuleOriginal;
import test.paye.eoy.bizrules.BusinessRuleTestCase;

/**
 * @author Rob
 */
public class TaxInPrevEmpRuleTest extends BusinessRuleTestCase {

    private final TaxInPrevEmpRuleOriginal rule = new TaxInPrevEmpRuleOriginal();

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        initializeRule(rule);
    }

    public void testRule38point4a() {
        rule.setTaxablePay("5.00");
        rule.setTax("10.00");
        rule.processRule();
        assertTrue("Should have thrown a Rule38.6 error", checkErrorRaised(rule, TaxInPrevEmpRuleOriginal.TAX_GT_TAXABLE_PAY));
    }

    public void testRule38point4b() {
        rule.setTaxablePay("5.00");
        rule.setTax("5.00");
        rule.processRule();
        assertTrue("Should not have thrown any errors", getErrors().size() == 0);
    }
}
