/*
 * Created on May 27, 2005
 * 
 * $Id: TaxInThisEmpRuleTest.java,v 1.3 2006/06/06 14:57:09 dec Exp $
 *  
 */
package test.paye.eoy.bizrules.p14;

import paye.eoy.bizrules.p14.payandtax.TaxInThisEmpRuleOriginal;
import test.paye.eoy.bizrules.BusinessRuleTestCase;

/**
 * @author Rob
 */
public class TaxInThisEmpRuleTest extends BusinessRuleTestCase {
    private final TaxInThisEmpRuleOriginal rule = new TaxInThisEmpRuleOriginal();

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        initializeRule(rule);
    }

    public void testRule40point1a() {
        rule.setTaxablePayThisEmp("10.00");
        rule.setTaxThisEmp("5.00");
        rule.processRule();
        assertTrue("Should not have thrown any errors", getErrors().size() == 0);
    }

    public void testRule40point1b() {
        rule.setTaxablePayThisEmp("10.00");
        rule.setTaxThisEmp("15.00");
        rule.processRule();
        assertTrue("Should have thrown a Rule40.1 error", checkErrorRaised(rule, TaxInThisEmpRuleOriginal.GT_PAY_THIS_EMP));
    }

    public void testRule40point2a() {
        rule.setTaxPrevEmp("10.00");
        rule.setTaxThisEmp("-5.00");
        rule.processRule();
        assertTrue("Should not have thrown any errors", getErrors().size() == 0);
    }

    public void testRule40point2b() {
        rule.setTaxPrevEmp("4.00");
        rule.setTaxThisEmp("-5.00");
        rule.processRule();
        assertTrue("Should have thrown a Rule40.2 error", checkErrorRaised(rule, TaxInThisEmpRuleOriginal.MUST_BE_LT_TAX_PREV_EMP));
    }

    public void testNegativeWithZeroPrev() {
        rule.setTaxPrevEmp("0.00");
        rule.setTaxThisEmp("-5.00");
        rule.processRule();
        assertTrue("Should have thrown a Rule40.2 error", checkErrorRaised(rule, TaxInThisEmpRuleOriginal.MUST_BE_LT_TAX_PREV_EMP));
    }

    public void testRule40point2c() {
        rule.setTaxPrevEmp("4.00");
        rule.setTaxThisEmp("5.00");
        rule.processRule();
        assertFalse("Should not have thrown a Rule40.2 error", checkErrorRaised(rule,
                TaxInThisEmpRuleOriginal.MUST_BE_LT_TAX_PREV_EMP));
    }

}
