/*
 * Created on May 25, 2005
 * 
 * $Id: TotalContributionsPayableRuleTest.java,v 1.3 2006/08/10 15:19:16 dec Exp $
 */
package test.paye.eoy.bizrules.p14;

import paye.eoy.bizrules.p14.nic.TotalContributionsPayableRuleOriginal;
import test.paye.eoy.bizrules.BusinessRuleTestCase;
import xmldoc.Attribute;
import xmldoc.AttributeDetail;

/**
 * @author Rob
 */
public class TotalContributionsPayableRuleTest extends BusinessRuleTestCase {

    public void testRule29point5a() {
        final TotalContributionsPayableRuleOriginal rule = new TotalContributionsPayableRuleOriginal();
        initializeRule(rule);
        rule.setNICs(new Attribute[] { new AttributeDetail("Tab", "A") });
        rule.setEmp("6.00");
        rule.setBoth("3.00");
        rule.processRule();
        assertTrue("Should have thrown a Rule29.5 error", checkErrorRaised(rule, TotalContributionsPayableRuleOriginal.BOTH_LT_EMP));

    }

    public void testRule29point6a() {
        final TotalContributionsPayableRuleOriginal rule = new TotalContributionsPayableRuleOriginal();
        initializeRule(rule);
        rule.setNICs(new Attribute[] { new AttributeDetail("Tab", "A") });
        rule.setBoth("-1.00");
        rule.processRule();
        assertTrue("Should have thrown a Rule29.6 error",
                checkErrorRaised(rule, TotalContributionsPayableRuleOriginal.BOTH_LT_ZERO));
    }

}
