/*
 * Created on May 31, 2005
 *
 * $Id: EmployeesOutOfUKRuleTest.java,v 1.4 2006/08/10 15:19:16 dec Exp $
 * 
 */
package test.paye.eoy.bizrules.p35;

import paye.eoy.bizrules.p35.AbstractP14RequiredIfAnsweredYesRule;
import paye.eoy.bizrules.p35.EmployeesOutOfUKRule;
import test.paye.eoy.bizrules.BusinessRuleTestCase;
import xmldoc.Attribute;
import xmldoc.AttributeDetail;
import xmldoc.ElementReference;
import xmldoc.SimpleElementReference;
import bizrules.registry.StartElementDetail;

/**
 * @author Jaco
 */
public class EmployeesOutOfUKRuleTest extends BusinessRuleTestCase {

    private final EmployeesOutOfUKRule rule = new EmployeesOutOfUKRule();

    private StartElementDetail detail;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        initializeRule(rule);

        final ElementReference ref = SimpleElementReference.makeReference("", "");
        detail = new StartElementDetail(ref, ref);
    }

    public void testRule104point1a() {
        rule.setAnswer("yes");
        rule.setAnswer(new Attribute[] { new AttributeDetail("IsIncluded", "yes") });
        rule.onP14(detail);
        rule.processRule();
        assertTrue("Should not have thrown any errors", getErrors().size() == 0);
    }

    public void testRule104point1b() {
        rule.setAnswer("yes");
        rule.processRule();
        assertTrue(checkErrorRaised(rule, AbstractP14RequiredIfAnsweredYesRule.BLANK_INC_YES_ANS));
    }
}
