/*
 * Created on Jun 1, 2005
 * 
 * $Id: NetStatutoryPaymentsRecoveredRuleTest.java,v 1.2 2005/09/28 11:16:28 dec
 * Exp $
 *  
 */
package test.paye.eoy.bizrules.p35;

import paye.eoy.bizrules.p35.NetStatutoryPaymentsRecoveredRule;
import test.paye.eoy.bizrules.BusinessRuleTestCase;

/**
 * @author Jaco
 */
public class NetStatutoryPaymentsRecoveredRuleTest extends BusinessRuleTestCase {

    private final NetStatutoryPaymentsRecoveredRule rule = new NetStatutoryPaymentsRecoveredRule();

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        initializeRule(rule);
    }

    public void testRule130point1a() {
        rule.setSsp("10.00");
        rule.setSmp("11.00");
        rule.setSmpCompensation("12.00");
        rule.setSpp("11.00");
        rule.setSppCompensation("12.00");
        rule.setSap("11.00");
        rule.setSapCompensation("12.00");
        rule.setNicHoliday("15.00");
        rule.setFunding("23.00");
        rule.setNetStatutoryPaymentsRecovered("71.00");

        rule.processRule();
        assertTrue("Should not have thrown any errors", getErrors().size() == 0);
    }

    public void testRule130point1b() {
        rule.setSsp("10.00");
        rule.setSmp("11.00");
        rule.setSmpCompensation("12.00");
        rule.setSpp("11.00");
        rule.setSppCompensation("12.00");
        rule.setSap("11.00");
        rule.setSapCompensation("12.00");
        rule.setNicHoliday("15.00");
        rule.setFunding("23.00");
        rule.setNetStatutoryPaymentsRecovered("91.00");

        rule.processRule();
        assertTrue("Should have thrown a Rule130.1 error", checkErrorRaised(rule, NetStatutoryPaymentsRecoveredRule.BAD_TOTAL));
    }
}
