/*
 * Created on Jun 2, 2005
 * 
 * $Id: RevisedAmountNowPayableRuleTest.java,v 1.2 2006/06/06 14:57:09 dec Exp $
 *  
 */
package test.paye.eoy.bizrules.p35;

import paye.eoy.bizrules.p35.RevisedAmountNowPayableRule;
import test.paye.eoy.bizrules.BusinessRuleTestCase;

/**
 * @author Jaco
 */
public class RevisedAmountNowPayableRuleTest extends BusinessRuleTestCase {

    public void testRule139a() {
        final RevisedAmountNowPayableRule rule = new RevisedAmountNowPayableRule();
        initializeRule(rule);
        rule.setTotalAfterCISdeductions("25.00");
        rule.setTotalRemainingToPay("35.00");
        rule.setCisDeductions("10.00");

        rule.processRule();
        assertTrue("Should not have thrown any errors", getErrors().size() == 0);
    }

    public void testRule139b() {
        final RevisedAmountNowPayableRule rule = new RevisedAmountNowPayableRule();
        initializeRule(rule);
        rule.setTotalAfterCISdeductions("27.00");
        rule.setTotalRemainingToPay("35.00");
        rule.setCisDeductions("10.00");
        rule.processRule();
        assertTrue("Should have thrown a Rule139.1 error", checkErrorRaised(rule, RevisedAmountNowPayableRule.BAD_TOTAL));
    }

}
