/*
 * Created on May 31, 2005
 * 
 * $Id: SAPRecoveredRuleTest.java,v 1.2 2006/06/06 14:57:09 dec Exp $
 *  
 */
package test.paye.eoy.bizrules.p35;

import paye.eoy.bizrules.p35.SAPRecoveredRuleOriginal;
import paye.eoy.bizrules.qs3.AbstractRecoveredRuleOriginal;
import test.paye.eoy.bizrules.BusinessRuleTestCase;

/**
 * @author Jaco
 */
public class SAPRecoveredRuleTest extends BusinessRuleTestCase {
    private final SAPRecoveredRuleOriginal rule = new SAPRecoveredRuleOriginal();

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        initializeRule(rule);
    }

    public void testRule126point1a() {
        rule.setValue("10.00");
        rule.setSuppliedTotal("10.0");
        rule.processRule();
        assertTrue("Should not have thrown any errors", getErrors().size() == 0);
    }

    public void testRule126point1b() {
        rule.setValue("10.00");
        rule.setSuppliedTotal("9.0");
        rule.processRule();
        assertTrue("Should not have thrown any errors", getErrors().size() == 0);
    }

    public void testRule126point1d() {
        rule.setValue("10.00");
        rule.setSuppliedTotal("15.0");
        rule.processRule();
        assertTrue("Should have thrown a Rule126.6 error", checkErrorRaised(rule, AbstractRecoveredRuleOriginal.BAD_TOTAL));
    }
}
