/*
 * Created on May 31, 2005
 *
 * $Id: ServicePaymentsRuleTest.java,v 1.4 2006/08/10 15:19:16 dec Exp $
 * 
 */
package test.paye.eoy.bizrules.p35;

import paye.eoy.bizrules.p35.AbstractP14RequiredIfAnsweredYesRule;
import paye.eoy.bizrules.p35.ServicePaymentsRule;
import test.paye.eoy.bizrules.BusinessRuleTestCase;
import xmldoc.Attribute;
import xmldoc.AttributeDetail;
import xmldoc.ElementReference;
import xmldoc.SimpleElementReference;
import bizrules.registry.DocumentEventDetail;
import bizrules.registry.StartElementDetail;

/**
 * @author Jaco
 */
public class ServicePaymentsRuleTest extends BusinessRuleTestCase {

    public void testRule104point1a() {
        final AbstractP14RequiredIfAnsweredYesRule rule = new ServicePaymentsRule();
        initializeRule(rule);
        rule.setAnswer("yes");
        rule.setAnswer(new Attribute[] { new AttributeDetail("IsIncluded", "yes") });

        final ElementReference ref = SimpleElementReference.makeReference("", "");
        final DocumentEventDetail detail = new StartElementDetail(ref, ref);
        rule.onP14(detail);
        rule.processRule();
        assertTrue("Should not have thrown any errors", getErrors().size() == 0);
    }

    public void testRule104point1b() {
        final AbstractP14RequiredIfAnsweredYesRule rule = new ServicePaymentsRule();
        initializeRule(rule);
        rule.setAnswer("yes");
        rule.processRule();
        assertTrue("Should have thrown a Rule108.3 error", checkErrorRaised(rule,
                AbstractP14RequiredIfAnsweredYesRule.BLANK_INC_YES_ANS));
    }

}
