/*
 * Created on May 31, 2005
 *
 * $Id: TotalNICRuleTest.java,v 1.2 2006/06/06 14:57:09 dec Exp $
 * 
 */
package test.paye.eoy.bizrules.p35;

import paye.eoy.bizrules.p35.TotalNICRuleComplete;
import test.paye.eoy.bizrules.BusinessRuleTestCase;

/**
 * @author Jaco
 */
public class TotalNICRuleTest extends BusinessRuleTestCase {
    private final TotalNICRuleComplete rule = new TotalNICRuleComplete();

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        initializeRule(rule);
    }

    public void testRule113point1a() {
        rule.setTotalNic("10.00");
        rule.setP14Nic("10.0");
        rule.processRule();
        assertTrue("Should not have thrown any errors", getErrors().size() == 0);
    }

    public void testRule113point1b() {
        rule.setTotalNic("15.00");
        rule.setP14Nic("10.0");
        rule.processRule();
        assertTrue("Should have thrown a Rule113.1 error", checkErrorRaised(rule, TotalNICRuleComplete.WRONG_TOTAL));

    }

}
