/*
 * Created on Jun 1, 2005
 * 
 * $Id: TotalNICSTaxAndStLoanRuleTest.java,v 1.2 2006/06/06 14:57:09 dec Exp $
 *  
 */
package test.paye.eoy.bizrules.p35;

import paye.eoy.bizrules.p35.TotalNICSTaxAndStLoanRule;
import test.paye.eoy.bizrules.BusinessRuleTestCase;

/**
 * @author Rob
 */
public class TotalNICSTaxAndStLoanRuleTest extends BusinessRuleTestCase {

    public void testRule120point1a() {
        final TotalNICSTaxAndStLoanRule rule = new TotalNICSTaxAndStLoanRule();
        initializeRule(rule);
        rule.setTotalTaxAndNIC("20.00");
        rule.setStudentLoan("10.00");
        rule.setTotalNICsTaxAndStudentLoan("30.00");
        rule.processRule();
        assertTrue("Should not have thrown any errors", getErrors().size() == 0);
    }

    public void testRule120point1b() {
        final TotalNICSTaxAndStLoanRule rule = new TotalNICSTaxAndStLoanRule();
        initializeRule(rule);
        rule.setTotalTaxAndNIC("20.00");
        rule.setStudentLoan("10.00");
        rule.setTotalNICsTaxAndStudentLoan("40.00");
        rule.processRule();
        assertTrue("Should have thrown a Rule120.1 error", checkErrorRaised(rule, TotalNICSTaxAndStLoanRule.BAD_TOTAL));
    }

}
