/*
 * Created on Jun 1, 2005
 * 
 * $Id: TotalTaxAndNICRuleTest.java,v 1.2 2006/06/06 14:57:09 dec Exp $
 *  
 */
package test.paye.eoy.bizrules.p35;

import paye.eoy.bizrules.p35.TotalTaxAndNICRule;
import test.paye.eoy.bizrules.BusinessRuleTestCase;

/**
 * @author Jaco
 */
public class TotalTaxAndNICRuleTest extends BusinessRuleTestCase {

    public void testRule118point1a() {
        final TotalTaxAndNICRule rule = new TotalTaxAndNICRule();
        initializeRule(rule);
        rule.setTotalNIC("20.00");
        rule.setTotalTax("45.00");
        rule.setTotalTaxAndNIC("65.00");
        rule.processRule();
        assertTrue("Should not have thrown any errors", getErrors().size() == 0);
    }

    public void testRule118point1b() {
        final TotalTaxAndNICRule rule = new TotalTaxAndNICRule();
        initializeRule(rule);
        rule.setTotalNIC("20.00");
        rule.setTotalTax("45.00");
        rule.setTotalTaxAndNIC("85.00");
        rule.processRule();
        assertTrue("Should have thrown a Rule118.1 error", checkErrorRaised(rule, TotalTaxAndNICRule.BAD_TOTAL));
    }

}
