package test.paye.eoy.bizrules.p35.br0506;

import paye.eoy.bizrules.p35.SPPRecoveredRuleOriginal;
import paye.eoy.bizrules.qs3.AbstractRecoveredRuleOriginal;
import test.paye.eoy.bizrules.BusinessRuleTestCase;

public class SPPRecoveredRuleOriginalTest extends BusinessRuleTestCase {
    private final SPPRecoveredRuleOriginal rule = new SPPRecoveredRuleOriginal();

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        initializeRule(rule);
    }

    /*
     * Test method for
     * 'paye.parser.EndOfYearReturn.rules.P35Part.SPPRecoveredRuleOriginal.processRule()'
     */
    public void testProcessRuleSuccess() {
        rule.setValue("23");
        rule.setValue("32");
        rule.setSuppliedTotal("55");

        rule.processRule();
        assertTrue("This should not have raised and error", getErrors().size() == 0);
    }

    public void testProcessRuleFailure() {
        rule.setValue("23");
        rule.setValue("15");
        rule.setSuppliedTotal("55");
        rule.processRule();
        assertTrue("This should have raised and error", checkErrorRaised(rule, AbstractRecoveredRuleOriginal.BAD_TOTAL));
    }
}
