/*
 * Created on 26-Jan-2006
 *
 * $Id: SubmissionStatusTest.java,v 1.3 2006/03/20 18:30:22 dec Exp $
 */
package test.paye.eoy.validator;

import hmrc.validator.result.QSResult;
import hmrc.validator.result.ValidationStatus;
import junit.framework.TestCase;
import paye.eoy.validator.SubmissionStatus;
import paye.eoy.validator.SubmissionStatusFactory;

/**
 * $Id: SubmissionStatusTest.java,v 1.3 2006/03/20 18:30:22 dec Exp $
 */
public class SubmissionStatusTest extends TestCase {

    public void test1() {

        final QSResult qs2Result = new QSResult();
        final QSResult qs3Result = new QSResult();

        qs2Result.setValidationStatus(ValidationStatus.PASSED);
        qs3Result.setValidationStatus(ValidationStatus.PASSED);
        final SubmissionStatus instance = SubmissionStatusFactory.getInstance(qs2Result, qs3Result);
        assertTrue("This should have been accepted", instance == SubmissionStatus.ACCEPTED);
    }

    public void test2() {

        final QSResult qs2Result = new QSResult();
        final QSResult qs3Result = new QSResult();

        qs2Result.setValidationStatus(ValidationStatus.TOLERATED);
        qs3Result.setValidationStatus(ValidationStatus.NOT_VALIDATED);
        final SubmissionStatus instance = SubmissionStatusFactory.getInstance(qs2Result, qs3Result);
        assertTrue("This should have been accepted", instance == SubmissionStatus.ACCEPTED);
    }

    public void test3() {

        final QSResult qs2Result = new QSResult();
        final QSResult qs3Result = new QSResult();

        qs2Result.setValidationStatus(ValidationStatus.FAILED);
        qs3Result.setValidationStatus(ValidationStatus.NOT_VALIDATED);
        final SubmissionStatus instance = SubmissionStatusFactory.getInstance(qs2Result, qs3Result);
        assertTrue("This should have been rejected", instance == SubmissionStatus.REJECTED);
    }

}
