package test.paye.eoy.validator.tools;

import java.io.*;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

import paye.eoy.validator.PAYEValidationParams;
import paye.eoy.validator.PAYEValidationResult;
import paye.eoy.validator.PAYEValidator;
import paye.multiyear.TaxYear;

import com.gsl.logging.LoggerFactory;

import ericResponse.output.error.ErrorXmlUtils;

public class PAYEValidatorRunner {

    private static final Logger LOGGER = LoggerFactory.getLogger("paye.eoy.validator");

    private static final boolean TOLERANCE_CHECK_REQUIRED_FLAG = true;

    public static void main(final String args[]) {
        if (args.length == 0) {
            LOGGER.warning("Usage: PAYEValidatorRunner <file to validate> [<tax year>]");
            System.exit(1);
        }

        try {
            final PAYEValidationParams params = makeParams();
            params.setToleranceCheckRequired(TOLERANCE_CHECK_REQUIRED_FLAG);

            final Reader reader = new BufferedReader(new FileReader(new File(args[0])));

            final TaxYear taxYear;
            if (args.length >= 2) {
                taxYear = TaxYear.fromString(args[1]);
            } else {
                final Date periodEndDate = ErrorXmlUtils.getPeriodEnd(reader);
                if (periodEndDate == null) {
                    taxYear = TaxYear.estimateFromCurrentDate();
                } else {
                    taxYear = TaxYear.estimateFromPeriodEndDate(periodEndDate);
                }
            }
            params.setTaxYear(taxYear);

            LOGGER.warning("TaxYear :" + taxYear);

            final PAYEValidationResult result = run(new File(args[0]), System.out, params);

            LOGGER.info(result.toString());
        } catch (final Exception e) {
            e.printStackTrace();
        }
    }

    public static PAYEValidationResult run(final File testFile, final PAYEValidationParams params) throws Exception {
        return run(testFile, (Writer) null, params);
    }

    public static PAYEValidationResult run(final File testFile, final OutputStream out, final PAYEValidationParams params)
            throws Exception {
        return run(testFile, new OutputStreamWriter(out), params);
    }

    public static PAYEValidationResult run(final File testFile, final Writer writer, final PAYEValidationParams params)
            throws Exception {
        final Reader reader = new BufferedReader(new FileReader(testFile));

        final PAYEValidator validator = new PAYEValidator();
        final PAYEValidationResult result = validator.validateSubmission(reader, writer, params);

        return result;
    }

    public static PAYEValidationParams makeParams() {
        final PAYEValidationParams params = new PAYEValidationParams();
        params.getResponseParams().setOutputExtraDetails(true);
        params.getResponseParams().setSortErrorsEnabled(true);
        params.getLoggingParams().setDefaultLevel(Level.INFO);
        return params;
    }
}
