package xmldoc;

public final class AttributeHelper {

    public static String getAttributeValue(final Attribute[] attrs, final String localName) {
        final Attribute attr = getAttribute(attrs, localName);
        return (attr != null) ? attr.getValue() : null;
    }

    public static Attribute getAttribute(final Attribute[] attrs, final String localName) {
        for (final Attribute attr : attrs) {
            if (attr.getLocalName().equals(localName)) {
                return attr;
            }
        }
        return null;
    }

    private AttributeHelper() {
    }
}
