package xmldoc;

import processingError.Location;
import processingError.ProcessingError;

public interface DocumentError extends ProcessingError {
    static final String UNKNOWN = "unknown";

    static final String SUPPRESS = "suppress";

    static final String BLANK = "blank";

    static final String MANDATORY = "mandatory";

    static final String FORMAT = "format";

    static final String INVALID = "invalid";

    static final String VALUE = "value";

    static final String MINVALUE = "minvalue";

    static final String MAXVALUE = "maxvalue";

    static final String ATTRIBUTE = "attribute";

    static final String LENGTH = "length";

    ElementReference getElementReference();

    Location getLocation();

    void setExtraInfo(Object extraInfo);

    void setSubCode(String subcode);

    void setLocation(Location location);

    void setXPathLocation(String location);

    /**
     * If the error is in an attribute then the creator of the error can name
     * the attribute here and it will get included when returning the XPath
     * location.
     */
    void setAttributeName(String attributeName);

    void setSAXErrorMessage(String message);

    public void setElementReference(ElementReference elementReference);
}
