/**
 * $Id: DocumentErrorBean.java,v 1.1 2006/08/10 15:19:10 dec Exp $
 */
package xmldoc;

import java.util.HashSet;
import java.util.Set;

import processingError.AbstractProcessingError;
import processingError.Location;

/**
 * @author Douglas Clinton
 * @since Mar 22, 2006
 * 
 */
public class DocumentErrorBean extends AbstractProcessingError implements DocumentError {

    private static Set<String> subCodeSet;

    public DocumentErrorBean(final Location location) {
        super(location);
    }

    private ElementReference elementReference;

    private Object underlyingError;

    private String subCode = UNKNOWN;

    private Object extraInfo = null;

    private Object valueInError;

    private String saxErrorMessage = "";

    private String xPathLocation = null;

    private String attributeName = null;

    public String getXPathLocation() {
        if (xPathLocation != null && attributeName != null) {
            return xPathLocation + "/@" + attributeName;
        }
        return xPathLocation;
    }

    public void setXPathLocation(final String pathLocation) {
        xPathLocation = pathLocation;
    }

    public String getAttributeName() {
        return attributeName;
    }

    public void setAttributeName(final String attributeName) {
        this.attributeName = attributeName;
    }

    @Override
    public boolean equals(final Object other) {
        boolean result = false;
        if (other != null && other.getClass() == getClass()) {
            final DocumentErrorBean that = (DocumentErrorBean) other;
            if (this.elementReference == null && that.elementReference == null && this.subCode.equals(that.subCode)
                    && this.extraInfo == null && that.extraInfo == null) {
                result = true;
            } else {
                result = this.elementReference != null && this.elementReference.equals(that.elementReference)
                        && this.subCode != null && this.subCode.equals(that.subCode);
                if (result) {
                    if (this.extraInfo != null) {
                        result = this.extraInfo.equals(that.extraInfo);
                    } else {
                        if (that.extraInfo != null) {
                            result = false;
                        }
                    }
                }
            }
        }
        return result;
    }

    @Override
    public int hashCode() {
        return ("" + elementReference + subCode + extraInfo).hashCode();
    }

    public ElementReference getElementReference() {
        return elementReference;
    }

    public Object getOriginalError() {
        return underlyingError;
    }

    public void setElementReference(final ElementReference elementReference) {
        this.elementReference = elementReference;
    }

    public void setUnderlyingError(final Object underlyingError) {
        this.underlyingError = underlyingError;
    }

    public void setSubCode(final String errorCode) {
        this.subCode = errorCode;
    }

    @Override
    public String getErrorCode() {
        return getSubCode();
    }

    public Object getExtraInfo() {
        return extraInfo;
    }

    public void setExtraInfo(final Object extraInfo) {
        this.extraInfo = extraInfo;
    }

    public String getRuleName() {
        return buildTagName();
    }

    public Object getValueInError() {
        return valueInError;
    }

    public void setValueInError(final Object valueInError) {
        this.valueInError = valueInError;
    }

    @Override
    public String toString() {
        String str = "DocumentError:" + super.toString();
        final String message = getSAXErrorMessage();
        if (message != null) {
            str += " (" + message + ")";
        }
        return str;
    }

    public String getSubCode() {
        return subCode;
    }

    public String getSAXErrorMessage() {
        return saxErrorMessage;
    }

    @Override
    public String getMessage() {
        return getSAXErrorMessage();
    }

    public void setSAXErrorMessage(final String message) {
        this.saxErrorMessage = message;
    }

    public static Set<String> getDocumentErrorSubCodes() {
        if (subCodeSet == null) {
            synchronized (DocumentErrorBean.class) {
                if (subCodeSet == null) {
                    final Set<String> newSubCodeSet = new HashSet<String>();

                    newSubCodeSet.add(DocumentError.ATTRIBUTE);
                    newSubCodeSet.add(DocumentError.BLANK);
                    newSubCodeSet.add(DocumentError.FORMAT);
                    newSubCodeSet.add(DocumentError.INVALID);
                    newSubCodeSet.add(DocumentError.MANDATORY);
                    newSubCodeSet.add(DocumentError.MAXVALUE);
                    newSubCodeSet.add(DocumentError.MINVALUE);
                    newSubCodeSet.add(DocumentError.VALUE);

                    subCodeSet = newSubCodeSet;
                }
            }
        }

        return subCodeSet;
    }

    public static boolean isDocumentErrorCode(final String subCode) {
        return getDocumentErrorSubCodes().contains(subCode);
    }

}
