package xmldoc;

import xmldoc.sax.XPathLocator;

/**
 * @author Douglas Clinton
 * @since Jan 27, 2006
 * 
 */
public interface DocumentEventReceiver {

    void startNamespace(String namespace);

    void endNamespace(String namespace);

    void startElement(ElementReference elementRef, Attribute[] attributes);

    void endElement(ElementReference elementRef);

    void elementText(ElementReference elementRef, char[] characters, int start, int length);

    void endDocument();

    void startDocument();

    void setXPathLocator(XPathLocator locator);

    /**
     * Give the event receiver a chance to handle a DocumentError.
     * 
     * @param error
     *            details of the error
     * @return true if the receiver handled the error sensible, false if it
     *         didn't know what to do with it.
     */
    boolean handleError(DocumentError error);
}
