package xmldoc;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Doug Clinton
 * 
 */
public final class DocumentEventType {
    private static final String START_ELEMENT_STRING = "startElement";

    private static final String END_ELEMENT_STRING = "endElement";

    private static final String ELEMENT_TEXT_STRING = "elementText";

    private static final String END_DOCUMENT_STRING = "endDocument";

    private static final String START_DOCUMENT_STRING = "startDocument";

    private static final String DOCUMENT_ERROR_STRING = "documentError";

    public static final DocumentEventType startElement = new DocumentEventType(START_ELEMENT_STRING);

    public static final DocumentEventType endElement = new DocumentEventType(END_ELEMENT_STRING);

    public static final DocumentEventType elementText = new DocumentEventType(ELEMENT_TEXT_STRING);

    public static final DocumentEventType startDocument = new DocumentEventType(START_DOCUMENT_STRING);

    public static final DocumentEventType endDocument = new DocumentEventType(END_DOCUMENT_STRING);

    public static final DocumentEventType documentError = new DocumentEventType(DOCUMENT_ERROR_STRING);

    private final String typeString;

    private static final Map<String, DocumentEventType> typeMap = new HashMap<String, DocumentEventType>();

    private DocumentEventType(final String typeString) {
        this.typeString = typeString;
    }

    static {
        typeMap.put(startElement.toString(), startElement);
        typeMap.put(endElement.toString(), endElement);
        typeMap.put(elementText.toString(), startElement);
        typeMap.put(startDocument.toString(), startDocument);
        typeMap.put(endDocument.toString(), endDocument);
    }

    @Override
    public String toString() {
        return typeString;
    }

    public static DocumentEventType fromString(final String typeString) {
        final DocumentEventType type = typeMap.get(typeString);
        if (type == null) {
            throw new IllegalArgumentException("Document event type '" + typeString + "' not supported");
        }
        return type;
    }
}
