/*
 * Created on May 25, 2005
 * 
 * $Id: DocumentLocation.java,v 1.1 2006/08/10 15:19:10 dec Exp $
 */
package xmldoc;

import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;

import processingError.Location;

/**
 * @author doug
 * @since May 25, 2005
 */
public class DocumentLocation implements Location {
    private final int lineNumber;

    private final int columnNumber;

    private ElementReference elementRef;

    private final Attributes attributes;

    public int getColumnNumber() {
        return columnNumber;
    }

    public int getLineNumber() {
        return lineNumber;
    }

    public DocumentLocation(final int lineNumber, final int columnNumber, final ElementReference ref, final Attributes attributes) {
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        if (ref != null) {
            this.elementRef = ref;
        } else {
            elementRef = SimpleElementReference.makeReference("", "");
        }
        this.attributes = attributes;
    }

    public DocumentLocation(final int lineNumber, final int columnNumber, final String tagName, final Attributes attributes) {
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.elementRef = SimpleElementReference.makeReference("", tagName);
        this.attributes = attributes;
    }

    public DocumentLocation(final int lineNumber, final int columnNumber, final String tagName) {
        this(lineNumber, columnNumber, tagName, null);
    }

    public DocumentLocation(final SAXParseException ex, final ElementReference elementRef) {
        this(ex.getLineNumber(), ex.getColumnNumber(), elementRef, null);
    }

    public String getTagName() {
        return elementRef.getXPath();
    }

    public Attributes getAttributes() {
        return attributes;
    }
}