/*
 * Created on Apr 8, 2006
 *
 * $Id: AbstractSAXExceptionDecoder.java,v 1.1 2006/08/10 15:19:10 dec Exp $
 */
package xmldoc.sax;

import org.xml.sax.SAXParseException;

import processingError.Location;
import xmldoc.DocumentErrorBean;
import xmldoc.DocumentLocation;
import xmldoc.ElementReference;

public abstract class AbstractSAXExceptionDecoder implements SAXExceptionDecoder {

    protected DocumentErrorBean makeDocumentError(final SAXParseException ex, final ElementReference resultRef, final String code,
            final String valueInError) {
        DocumentErrorBean result;
        final Location location = new DocumentLocation(ex, resultRef);
        result = new DocumentErrorBean(location);
        result.setSAXErrorMessage(ex.getMessage());
        result.setElementReference(resultRef);
        result.setUnderlyingError(ex);
        result.setSubCode(code);
        result.setValueInError(valueInError);
        return result;
    }

}
