/**
 * 
 */
package xmldoc.sax;

import xmldoc.DocumentError;

/**
 * This interface provides a way for an error to be given to another component
 * for further processing. I added this originally so that the SAXErrorDecoders
 * could pass errors back to the BusinessRuleRegistry to allow the DocumentError
 * locators to be updated as, in a lot of cases, Xerces delivers an error event
 * before the startElement event for the element that actually caused the error.
 * 
 * @author doug
 * 
 */
public interface DocumentErrorPostProcessor {

    public enum FixupType {
        // Keep the error around for fixup until the next start element
        // event.
        UntilStartElement,
        // Remove the error from the fixup list on the next end element
        // event, if that occurs before the next start element event.
        UntilEndElement
    }

    // FixupType defaults to UntilStartElement
    public void scheduleErrorForProcessing(DocumentError error);

    public void scheduleErrorForProcessing(DocumentError error, FixupType type);
}
