package xmldoc.sax;

import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;

import processingError.ProcessingErrorCollector;
import xmldoc.NamespacePrefixMapper;

public interface DocumentHandler extends EntityResolver, DTDHandler, ContentHandler, ErrorHandler {

    void interrupt();

    void setErrorCollector(final ProcessingErrorCollector errorCollector);

    void setEntityResolver(EntityResolver entityResolver);

    void setExceptionDecoder(SAXExceptionDecoder exceptionDecoder);

    void setNamespacePrefixMapper(NamespacePrefixMapper namespacePrefixMapper);

    void setDumpBusinessErrorsOnDocumentError(boolean dumpBusinessErrorsOnDocumentError);

    void addDocumentErrorFilter(DocumentErrorFilter filter);
}
