/*
 * Created on Apr 8, 2006
 *
 * $Id: NullSAXExceptionDecoder.java,v 1.1 2006/08/10 15:19:10 dec Exp $
 */
package xmldoc.sax;

import org.xml.sax.SAXParseException;

import xmldoc.DocumentError;
import xmldoc.ElementReference;

public class NullSAXExceptionDecoder extends AbstractSAXExceptionDecoder {

    private final String error;

    public NullSAXExceptionDecoder() {
        this(DocumentError.UNKNOWN);
    }

    public NullSAXExceptionDecoder(final String error) {
        this.error = error;
    }

    public DocumentError decodeException(final ElementReference elementRef, final SAXParseException ex) {
        return makeDocumentError(ex, elementRef, error, null);
    }

    public DocumentError decodeException(final ElementReference elementRef, final XPathLocationStack locationStack,
            final SAXParseException ex) {
        final DocumentError documentError = makeDocumentError(ex, elementRef, error, null);
        documentError.setXPathLocation(locationStack.getCurrentXPath());

        return documentError;
    }

    public void setDocumentErrorPostProcessor(final DocumentErrorPostProcessor ruleRegistry) {
        // do nothing
    }

}
