/*
 * Created on Apr 8, 2006
 *
 * $Id: SAXExceptionDecoder.java,v 1.1 2006/08/10 15:19:10 dec Exp $
 */
package xmldoc.sax;

import org.xml.sax.SAXParseException;

import xmldoc.DocumentError;
import xmldoc.ElementReference;

public interface SAXExceptionDecoder {

    /**
     * Given an element reference and a SAXParserException this method will
     * generate a DocumentError which attempts to reflect the meaning of the
     * exception by inferring a DocumentError code. In addition, the
     * ElementReference held in the DocumentError may have been 'fixed-up', i.e.
     * changed to more accurately reflect the true position of the error since a
     * SAX implementation can report errors on the parent tag of the element
     * where the problem actually occured.
     */
    DocumentError decodeException(ElementReference elementRef, SAXParseException ex);

    void setDocumentErrorPostProcessor(DocumentErrorPostProcessor ruleRegistry);

}
