/**
 * 
 */
package xmldoc.sax;

import java.util.HashMap;
import java.util.Map;

import xmldoc.NamespacePrefixMapper;

/**
 * @author douglas
 * 
 */
public class SimpleNamespacePrefixMapper implements NamespacePrefixMapper {

    /**
     * Provide some hard-coded mappings for the standard HMRC namespaces.
     */
    private static final String[][] prefixMapData = { { "http://www.govtalk.gov.uk/CM/envelope", "hd" },
            { "http://www.w3.org/2000/09/xmldsig#", "dsig" } };

    private final Map<String, String> namespaceToPrefixMap = new HashMap<String, String>();

    private final Map<String, String> prefixToNamespaceMap = new HashMap<String, String>();

    public SimpleNamespacePrefixMapper() {
        this(prefixMapData);
    }

    public SimpleNamespacePrefixMapper(final String[][] initializationData) {
        addMappings(initializationData);
    }

    public String mapNamespaceToPrefix(final String namespace) {
        return namespaceToPrefixMap.get(namespace);
    }

    public String mapPrefixToNamespace(final String prefix) {
        return prefixToNamespaceMap.get(prefix);
    }

    /**
     * If a mapping is already in place for the namespace then it will not be
     * overwritten by this call.
     */
    public void addMapping(final String namespace, final String prefix) {
        if (!namespaceToPrefixMap.containsKey(namespace)) {
            namespaceToPrefixMap.put(namespace, prefix);
            prefixToNamespaceMap.put(prefix, namespace);
        }
    }

    public void addMappings(final String[][] mappings) {
        for (final String[] element : mappings) {
            addMapping(element[0], element[1]);
        }
    }
}
