/*
 * Created on Sep 7, 2005
 *
 */
package xmldoc.sax;

/**
 * The only way I know of to terminate a SAX parser before the end of the
 * document is to throw an exception/error. This 'error' exists to allow a SAX
 * processor to do just that if, for some reason, it is not interested in the
 * remainder of a document.
 * 
 * Although normally it is bad practice to use a throwable to deal with normal
 * execution flow, in this case I know of no other way. The catcher of this
 * 'error' should regard it as benign and carry on as if the parse had finished
 * normally.
 * 
 * @author Doug Clinton
 */
public class TerminateParse extends Error {

    private static final long serialVersionUID = -7909776272868079764L;

    private static final String DEFAULT_MESSAGE = "SAX Parse deliberately terminated early by the processor - this is benign";

    public TerminateParse() {
        super(DEFAULT_MESSAGE);
    }

    public TerminateParse(final String arg0) {
        super(arg0);
    }

    public TerminateParse(final Throwable arg0) {
        super(DEFAULT_MESSAGE, arg0);
    }

    public TerminateParse(final String arg0, final Throwable arg1) {
        super(arg0, arg1);
    }
}
