/**
 * 
 */
package xmldoc.sax;

import java.util.HashMap;
import java.util.Map;

class XPathLocationStackFrame implements Cloneable {

    private static final Integer ONE = new Integer(1);

    private final Map<String, Integer> childElementCounts = new HashMap<String, Integer>();

    private final String namespace;

    private final String prefixedElementName;

    private final String elementName;

    private int index = 1;

    private String xPath;

    public XPathLocationStackFrame(final XPathLocationStackFrame parent, final String namespace, final String elementName,
            final String prefixedElementName) {
        this.namespace = namespace;
        this.elementName = elementName;
        this.prefixedElementName = prefixedElementName;
        if (parent != null) {
            this.index = countChildren(parent, elementName);
        }
        this.xPath = (parent == null ? "/" : parent.xPath + "/") + prefixedElementName;
    }

    @Override
    public XPathLocationStackFrame clone() {
        final XPathLocationStackFrame clonedFrame = new XPathLocationStackFrame(null, namespace, elementName, prefixedElementName);
        clonedFrame.xPath = xPath;
        clonedFrame.index = index;

        // childElementCounts maps Strings to Integers so it is not necessary to
        // do a 'deep' clone on it. Simply setting up a new map (as is done
        // during construction of the clone) will suffice.
        clonedFrame.childElementCounts.putAll(childElementCounts);

        return clonedFrame;
    }

    public String getElementName() {
        return elementName;
    }

    public String getPrefixedElementName() {
        return prefixedElementName;
    }

    public int getElementIndex() {
        return index;
    }

    public String getNamespace() {
        return namespace;
    }

    public String getXPath() {
        return xPath;
    }

    private static int countChildren(final XPathLocationStackFrame frame, final String elementName) {
        int newCount = 1;
        if (frame != null) {
            final Integer elementCount = frame.childElementCounts.get(elementName);
            if (elementCount != null) {
                newCount = elementCount.intValue() + 1;
                frame.childElementCounts.put(elementName, new Integer(newCount));
            } else {
                frame.childElementCounts.put(elementName, ONE);
            }
        }
        return newCount;
    }
}
