package xmldoc.util;

import java.util.logging.Logger;

import com.gsl.logging.LoggerFactory;

public abstract class AbstractEntityResolver implements EntityResolver {

    private Logger logger;

    protected final EntityResolutionMap entityResolutionMap;

    private final String name;

    protected AbstractEntityResolver() {
        this((EntityResolutionMap) null);
    }

    protected AbstractEntityResolver(final String name, final String[][] entityResolutionTable) {
        final EntityResolutionMapBuilder mapBuilder = new EntityResolutionMapBuilder();
        mapBuilder.add(entityResolutionTable);
        this.name = name;
        this.entityResolutionMap = mapBuilder.makeEntityResolutionMap();
    }

    protected AbstractEntityResolver(final EntityResolutionMap entityResolutionMap) {
        this.entityResolutionMap = entityResolutionMap;
        this.name = "anonymous";
    }

    protected AbstractEntityResolver(final String name, final EntityResolutionMap entityResolutionMap) {
        this.name = name;
        this.entityResolutionMap = entityResolutionMap;
    }

    public EntityResolutionMap getMap() {
        return entityResolutionMap;
    }

    public String getExternalSchemaLocations() {
        return entityResolutionMap.getExternalSchemaLocations();
    }

    protected Logger getLogger() {
        // Defer initialization of the logger until it is needed. Creating it
        // statically can cause it to be set up before the default log level has
        // been set on the LoggerFactory.
        if (logger == null) {
            logger = LoggerFactory.getLogger("xmldoc.util.entityResolver");
        }
        return logger;
    }

    @Override
    public String toString() {
        return "EntityResolver: " + name;
    }
}
