package xmldoc.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;

import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import com.gsl.io.core.stream.StreamUtils;
import com.gsl.io.core.stream.Streamable;

public class CachingFileSystemEntityResolver extends AbstractEntityResolver {

    private final Map<String, byte[]> entityUriToByteArrayMap = new HashMap<String, byte[]>();

    public CachingFileSystemEntityResolver(final EntityResolutionMap entityResolutionMap) throws SAXException {
        super(entityResolutionMap);

        // Load all entity files and cache them from this point forward.
        for (final Iterator<Map.Entry<String, Streamable>> i = entityResolutionMap.getStreamableEntrySetIterator(); i.hasNext();) {
            final Map.Entry<String, Streamable> entry = i.next();
            final String entityUri = entry.getKey();
            final Streamable entityStreamable = entry.getValue();
            byte[] bytes = null;

            try {
                bytes = StreamUtils.readAllBytesFromStream(entityStreamable.openInputStream());
            } catch (final IOException ioEx) {
                getLogger().log(Level.SEVERE,
                        "Could not load schema file " + entityStreamable.toString() + " for namespace " + entityUri, ioEx);
                throw new SAXException("Could not load schema file " + entityStreamable.toString() + " for namespace " + entityUri,
                        ioEx);
            }

            entityUriToByteArrayMap.put(entityUri, bytes);
        }
    }

    public InputSource resolveEntity(final String publicId, final String systemId) throws SAXException {
        InputSource resolvedInputSource = null;

        if (systemId != null) {
            final byte[] bytes = entityUriToByteArrayMap.get(systemId);
            if (bytes != null) {
                final InputStream stream = new ByteArrayInputStream(bytes);
                resolvedInputSource = new InputSource(stream);
            }
        }

        return resolvedInputSource;
    }
}
