package xmldoc.util;

import java.io.InputStream;

import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ClasspathEntityResolver extends AbstractEntityResolver {

    public ClasspathEntityResolver(final String name, final String[][] entityResolutionTable) {
        super(name, entityResolutionTable);
    }

    public ClasspathEntityResolver(final String[][] entityResolutionTable) {
        super("anonymous", entityResolutionTable);
    }

    public void addTableEntry(final String namespace, final String xsdPath) {
        getMap().addLocationEntry(namespace, xsdPath);
    }

    public InputSource resolveEntity(final String publicId, final String systemId) throws SAXException {
        InputSource resolvedInputSource = null;
        final String entityLocation = entityResolutionMap.getLocationFor(systemId);

        if (entityLocation != null) {
            final InputStream stream = getClass().getResourceAsStream(entityLocation);

            if (stream != null) {
                resolvedInputSource = new InputSource(stream);
            } else {
                getLogger().severe("Could not load schema file " + entityLocation + " for namespace " + systemId);
                throw new SAXException("Could not load schema file " + entityLocation + " for namespace " + systemId);
            }
        }

        return resolvedInputSource;
    }
}
