package xmldoc.util;

import java.util.Iterator;
import java.util.Map;

import com.gsl.io.core.stream.Streamable;

/**
 * An immutable map of [namespace of an entity ==> location of that entity].
 * 
 * @author rhys
 */

public class EntityResolutionMap {

    private final Map<String, String> uriToLocationMap;

    private final Map<String, Streamable> uriToStreamableMap;

    public EntityResolutionMap(final Map<String, String> uriToLocationMap, final Map<String, Streamable> uriToNamedInputStreamMap) {
        this.uriToLocationMap = uriToLocationMap;
        this.uriToStreamableMap = uriToNamedInputStreamMap;
    }

    public boolean containsRow(final String uri, final String location) {
        final String mapEntryLocation = uriToLocationMap.get(uri);
        return ((mapEntryLocation != null) && mapEntryLocation.endsWith(location));
    }

    public String getLocationFor(final String uri) {
        return uriToLocationMap.get(uri);
    }

    public Iterator<Map.Entry<String, String>> getLocationEntrySetIterator() {
        return uriToLocationMap.entrySet().iterator();
    }

    public Iterator<Map.Entry<String, Streamable>> getStreamableEntrySetIterator() {
        return uriToStreamableMap.entrySet().iterator();
    }

    public String getExternalSchemaLocations() {
        final StringBuffer buffer = new StringBuffer(512);

        for (final String uri : uriToLocationMap.keySet()) {
            buffer.append(uri).append(" ").append(uri).append(" ");
        }

        return buffer.toString();
    }

    public void addLocationEntry(final String namespace, final String xsdPath) {
        uriToLocationMap.put(namespace, xsdPath);
    }
}
